
#This has to do with the following bioassays
# Beetroot - Pythium                          # bee
# Onion - Fusarium                            # oni2
# Spinach - Pythium                           # spi1
# Coriander - Pythium                         # cor
# Pepper - Phytophthora capsici SEEDS         # pep2 / pepperSeeds


# import data -------------------------------------------------------------
#need to set working directory
#setwd()
source("02 data analysis.R") #the output of that script is full_summary2
all_data <- full_summary2
all_data$LotCode <- paste(all_data$SeedLot, '_', all_data$BioassayType)  

#continuous data
beetroot <- read.csv("Beetroot4R_data.csv")
onion <- read.csv("Onion4R_data.csv")
spinach <- read.csv("Spinach4R_data.csv")
coriander <- read.csv("Coriander4R_data.csv")
pepperSeeds <- read.csv('Pepper_seeds_4Rdata.csv')

# 
# Packages ----------------------------------------------------------------
# library(ggplot2)
# library(tidyverse)
# library(ggpubr)
# library(ggrepel)
# 
# library(gridExtra)
# library(cowplot)
# library(ggtext)
# library(ggstance)
# library(ggExtra)
# 
# library(plyr) #ddply for medians for ordinal pepper


set_breaks = function(limits) {
  seq(limits[1], limits[2], by = 1)
}

# graph extensions -----------------------------------------------------------------------

a.ex <- list(theme_bw() + theme(axis.text.x = element_text(angle = 45), 
                     legend.key.height=unit(0.5,"line")) +
  theme(plot.margin = margin(1,1,0,1),
        plot.title = element_text(size = 12), 
        axis.title.x = element_blank(), 
        axis.text.x = element_blank(),
        axis.text.y = element_text(size = 12), 
        axis.title.y = element_text(size = 12),
        legend.title = element_text(size = 12),
        legend.text = element_text(size = 12)) + 
  removeGridY())

b.ex <- list(theme_void() + theme(plot.margin = margin(0,1,1,1), legend.position = 'none'))

# Beetroot - Pythium data prep -----------------------------------------------------------------------
beetroot$LotCode <- paste(beetroot$SeedLot, '_', 'Beetroot_Pythium')  
beetroot$var1 <- all_data$Bio_var1[match(beetroot$LotCode, all_data$LotCode)]
beetroot$var2 <- all_data$Bio_var2[match(beetroot$LotCode, all_data$LotCode)]
beetroot$reject_en <- all_data$Ger_energy[match(beetroot$LotCode, all_data$LotCode)]
beetroot$reject_cap <- all_data$Ger_capacity[match(beetroot$LotCode, all_data$LotCode)]
beetroot<-beetroot[!(beetroot$reject_en=="affected" | beetroot$reject_cap=="affected"),]

# Beetroot - Pythium variable 1 A1 -----------------------------------------------------------------------
head(beetroot)
beetroot$SeedLot <- as.character(beetroot$SeedLot)

a1.1 <- ggplot(beetroot, aes(x=SeedLot, y=Inf_pre)) + 
  a.ex + geom_boxplot(alpha=0.1,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("A1. Beetroot -"~italic(Pythium)~~italic(ultimum)~"; pre-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a1 <- a1.1 + theme(legend.position='none')

b1 <- ggplot (beetroot, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"),
                     labels = c('Positively responsive seed lots',
                                'Non-responsive seed lots', 
                                'Negatively responsive seed lots'))



c1.1 <- plot_grid(a1, b1, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c1 <- plot_grid(c1.1, get_legend(a1.1), ncol=2, rel_widths = c(1, 0.2))

# Beetroot - Pythium variable 2 A2-----------------------------------------------------------------------
head(beetroot)
beetroot$SeedLot <- as.character(beetroot$SeedLot)

a2.2 <- ggplot(beetroot, aes(x=SeedLot, y=Inf_post)) + 
  a.ex + geom_boxplot(alpha=0.5,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("A2. Beetroot -"~italic(Pythium)~~italic(ultimum)~"; post-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a2 <- a2.2 + theme(legend.position='none')

b2 <- ggplot (beetroot, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c2.2 <- plot_grid(a2, b2, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c2 <- plot_grid(c2.2, get_legend(a2.2), ncol=2, rel_widths = c(1, 0.2))
# Onion - Fusarium data prep -----------------------------------------------------------------------

onion$LotCode <- paste(onion$SeedLot, '_', 'Onion_Fusarium')  
onion$var1 <- all_data$Bio_var1[match(onion$LotCode, all_data$LotCode)]
onion$var2 <- all_data$Bio_var2[match(onion$LotCode, all_data$LotCode)]
onion$reject_en <- all_data$Ger_energy[match(onion$LotCode, all_data$LotCode)]
onion$reject_cap <- all_data$Ger_capacity[match(onion$LotCode, all_data$LotCode)]
onion<-onion[!(onion$reject_en=="affected" | onion$reject_cap=="affected"),]

# Onion - Fusarium variable 1 C1 -----------------------------------------------------------------------
head(onion)
onion$SeedLot <- as.character(onion$SeedLot)

a3.3 <- ggplot(onion, aes(x=SeedLot, y=Inf_pre_13)) + 
  a.ex + geom_boxplot(alpha=0.1,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
  position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("C1. Onion -"~italic(Fusarium)~~italic(oxysporum)~"; pre-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a3 <- a3.3 + theme(legend.position='none')

b3 <- ggplot (onion, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c3.3 <- plot_grid(a3, b3, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c3 <- plot_grid(c3.3, get_legend(a3.3), ncol=2, rel_widths = c(1, 0.2))

# Onion - Fusarium variable 2 C2 -----------------------------------------------------------------------
head(onion)
onion$SeedLot <- as.character(onion$SeedLot)

a4.4 <- ggplot(onion, aes(x=SeedLot, y=Inf_post_13)) + 
  a.ex + geom_boxplot(alpha=0.5,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("C2. Onion -"~italic(Fusarium)~~italic(oxysporum)~"; post-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a4 <- a4.4 + theme(legend.position='none')

b4 <- ggplot (onion, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c4.4 <- plot_grid(a4, b4, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c4 <- plot_grid(c4.4, get_legend(a4.4), ncol=2, rel_widths = c(1, 0.2))


# Spinach - Pythium data prep -----------------------------------------------------------------------
#correct for FDR
all_data$Bio_var1[which(
  all_data$SeedLot %in% c(325, 337)&
    all_data$BioassayType %in% 
    c('Spinach_Pythium'))] <- 'Non-responsive seed lots'

#var1 - 100-Emerge_fin    
#var2 - Inf_post
head(spinach)
spinach$Inf_pre <- 100*(63 - spinach$Emerge_count_fin)/63
spinach$Inf_post <- 100*(spinach$Inf_count_post)/63


spinach$LotCode <- paste(spinach$SeedLot, '_', 'Spinach_Pythium')  
spinach$var1 <- all_data$Bio_var1[match(spinach$LotCode, all_data$LotCode)]
spinach$var2 <- all_data$Bio_var2[match(spinach$LotCode, all_data$LotCode)]
spinach$reject_en <- all_data$Ger_energy[match(spinach$LotCode, all_data$LotCode)]
spinach$reject_cap <- all_data$Ger_capacity[match(spinach$LotCode, all_data$LotCode)]
spinach<-spinach[!(spinach$reject_en=="affected" | spinach$reject_cap=="affected"),]

# Spinach - Pythium variable 1 D1 -----------------------------------------------------------------------
head(spinach)
spinach$SeedLot <- as.character(spinach$SeedLot)

a5.5 <- ggplot(spinach, aes(x=SeedLot, y=Inf_pre)) + 
  a.ex + geom_boxplot(alpha=0.1,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("D1. Spinach -"~italic(Pythium)~~italic(ultimum)~"; pre-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a5 <- a5.5 + theme(legend.position='none')

b5 <- ggplot (spinach, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c5.5 <- plot_grid(a5, b5, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c5 <- plot_grid(c5.5, get_legend(a5.5), ncol=2, rel_widths = c(1, 0.2))

# Spinach - Pythium variable 2 D2 -----------------------------------------------------------------------
head(spinach)
spinach$SeedLot <- as.character(spinach$SeedLot)

a6.6 <- ggplot(spinach, aes(x=SeedLot, y=Inf_post)) + 
  a.ex + geom_boxplot(alpha=0.5,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("D2. Spinach -"~italic(Pythium)~~italic(ultimum)~"; post-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a6 <- a6.6 + theme(legend.position='none')

b6 <- ggplot (spinach, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c6.6 <- plot_grid(a6, b6, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c6 <- plot_grid(c6.6, get_legend(a6.6), ncol=2, rel_widths = c(1, 0.2))

# Coriander - Pythium data prep -----------------------------------------------------------------------
coriander$Inf_pre <- 100 - coriander$total_emerge2
coriander$LotCode <- paste(coriander$SeedLot, '_', 'Coriander_Pythium')  
coriander$var1 <- all_data$Bio_var1[match(coriander$LotCode, all_data$LotCode)]
coriander$var2 <- all_data$Bio_var2[match(coriander$LotCode, all_data$LotCode)]
coriander$reject_en <- all_data$Ger_energy[match(coriander$LotCode, all_data$LotCode)]
coriander$reject_cap <- all_data$Ger_capacity[match(coriander$LotCode, all_data$LotCode)]
coriander<-coriander[!(coriander$reject_en=="affected" | coriander$reject_cap=="affected"),]

# Coriander - Pythium variable 1 F1 -----------------------------------------------------------------------
head(coriander)
coriander$SeedLot <- as.character(coriander$SeedLot)

a7.7 <- ggplot(coriander, aes(x=SeedLot, y=Inf_pre)) + 
  a.ex + geom_boxplot(alpha=0.1,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("F1. Coriander -"~italic(Pythium)~" sp.; pre-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a7 <- a7.7 + theme(legend.position='none')

b7 <- ggplot (coriander, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c7.7 <- plot_grid(a7, b7, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c7 <- plot_grid(c7.7, get_legend(a7.7), ncol=2, rel_widths = c(1, 0.2))

# Coriander - Pythium variable 2 F2 -----------------------------------------------------------------------
head(coriander)
coriander$SeedLot <- as.character(coriander$SeedLot)

a8.8 <- ggplot(coriander, aes(x=SeedLot, y=Inf_post2)) + 
  a.ex + geom_boxplot(alpha=0.5,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("F2. Coriander -"~italic(Pythium)~" sp.; post-emergence d.o. infection (%) ") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a8 <- a8.8 + theme(legend.position='none')

b8 <- ggplot (coriander, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c8.8 <- plot_grid(a8, b8, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c8 <- plot_grid(c8.8, get_legend(a8.8), ncol=2, rel_widths = c(1, 0.2))
# Pepper seedlings - Phytophthora capsici data prep -----------------------------------------------------------------------
head(pepperSeeds)
pepperSeeds <- na.omit(pepperSeeds)

pepperSeeds$Inf_pre <-  pepperSeeds$Ev3_missing / 8 *100 #var1 - Ev3_missing    
pepperSeeds$Inf_post <- pepperSeeds$Ev3_dead / 8 *100 #var2 - Ev3_dead

pepperSeeds$LotCode <- paste(pepperSeeds$SeedLot, '_', 'Pepper seeds_Phytophthora capsici')  
pepperSeeds$var1 <- all_data$Bio_var1[match(pepperSeeds$LotCode, all_data$LotCode)]
pepperSeeds$var2 <- all_data$Bio_var2[match(pepperSeeds$LotCode, all_data$LotCode)]
pepperSeeds$reject_en <- all_data$Ger_energy[match(pepperSeeds$LotCode, all_data$LotCode)]
pepperSeeds$reject_cap <- all_data$Ger_capacity[match(pepperSeeds$LotCode, all_data$LotCode)]
pepperSeeds<-pepperSeeds[!(pepperSeeds$reject_en=="affected" | pepperSeeds$reject_cap=="affected"),]

# Pepper seedlings - Phytophthora capsici variable 1 H1 -----------------------------------------------------------------------
head(pepperSeeds)
pepperSeeds$SeedLot <- as.character(pepperSeeds$SeedLot)

a9.9 <- ggplot(pepperSeeds, aes(x=SeedLot, y=Inf_pre)) + 
  a.ex + geom_boxplot(alpha=0.1,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("H1. Pepper seedlings -"~italic(Phytophthora)~~italic(capsici)~"; pre-emergence d.o. infection (%)") +
  labs(y="Infection (%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a9 <- a9.9 + theme(legend.position='none')

b9 <- ggplot (pepperSeeds, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var1), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c9.9 <- plot_grid(a9, b9, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c9 <- plot_grid(c9.9, get_legend(a9.9), ncol=2, rel_widths = c(1, 0.2))

# Pepper seedlings - Phytophthora capsici variable 2 H2 -----------------------------------------------------------------------
head(pepperSeeds)
pepperSeeds$SeedLot <- as.character(pepperSeeds$SeedLot)

a10.10 <- ggplot(pepperSeeds, aes(x=SeedLot, y=Inf_post)) + 
  a.ex + geom_boxplot(alpha=0.5,lwd=0.6, aes(color=MRTrt), outlier.alpha = 1,
                      position = position_dodge(width = 0.4))  +
  scale_color_manual(values = c("#7570B3", "#f768a1"), labels = c('Treated', 'Non-treated'))  + 
  ggtitle("H2. Pepper seedlings -"~italic(Phytophthora)~~italic(capsici)~"; dead seedlings (%) ") +
  labs(y="Dead seedlings(%)", x=element_blank(), color = "Treatment")  +  
  guides(color = guide_legend(override.aes = list(size = 1))) + 
  coord_cartesian(ylim = c(0, 100))

a10 <- a10.10 + theme(legend.position='none')

b10 <- ggplot (pepperSeeds, aes(x=SeedLot, y=0)) +
  geom_point(aes(color=var2), size = 2) + b.ex +
  scale_color_manual(values = c("Promising seed lots" ="#00AFBB",
                                "Non-responsive seed lots" ="#E7B800", 
                                "Negatively responsive seed lots" = "#FC4E07"))

c10.10 <- plot_grid(a10, b10, nrow = 2, rel_heights = c(0.8, 0.05), align = "v")

c10 <- plot_grid(c10.10, get_legend(a10.10), ncol=2, rel_widths = c(1, 0.2))


# rename graphs  -------------------------------------------------------------
abeet1  <- a1.1
abeet2  <- a2.2
aonifus1 <- a3.3
aonifus2 <- a4.4
aspipy1  <- a5.5
aspipy2  <- a6.6
acor1  <- a7.7
acor2  <- a8.8
apepsee1  <- a9.9
apepsee2  <- a10.10

cbeet1  <- c1.1
cbeet2  <- c2.2
conifus1 <- c3.3
conifus2 <- c4.4
cspipy1  <- c5.5
cspipy2  <- c6.6
ccor1  <- c7.7
ccor2  <- c8.8
cpepsee1  <- c9.9 #go first
cpepsee2  <- c10.10 #go first


